<?php 
session_start();

include("../../../sql_connect.php");
include("functions.php");

$user_data = check_login($dbc);

function build_url($params = []) {
    $base_url = "codex.php";
    $query = array_merge($_GET, $params); // Merge new params with existing ones
    return $base_url . '?' . http_build_query($query);
}

$table = isset($_GET['table']) ? $_GET['table'] : 'w';
switch ($table) {
    case "w":
        $t = "`warframes`";
        break;
    case "p":
        $t = "`primaries`";
        break;
    case "s":
        $t = "`secondaries`";
        break;
    case "m":
        $t = "`melees`";
        break;
    default:
        $t = "`warframes`";
        break;
}

$order = isset($_GET['order']) ? $_GET['order'] : 'n';
switch ($order) {
    case "n":
        $sort = "`NAME`";
        break;
    case "rd":
        $sort = "`RELEASE_DATE`";
        break;
    case "rot":
        $sort = "`RELEASE_ORDER_OF_TYPE`";
        break;
    default:
        $sort = "`NAME`";
        break;
}

$current_dir = $_GET['order_dir'] ?? 'asc';

function toggle_order_dir($order_key) {
    global $order, $current_dir;
    return ($order_key === $order && $current_dir === 'asc') ? 'desc' : 'asc';
}
?>

<!DOCTYPE html>
<html lang="en">
<?php require("assets/includes/head.html") ?>
<title>Builds - Warpon Prime</title>
        <?php include("assets/includes/header.php"); ?>

        <main>
            <div class="sortBar">
                <a class="sortBarText" href="<?php echo build_url(['table' => 'w']) ?>">
                    Warframes
                </a>
                <h1 class="sortBarCut">|</h1>
                <a class="sortBarText" href="<?php echo build_url(['table' => 'p']) ?>">
                    Primary Weapons
                </a>
                <h1 class="sortBarCut">|</h1>
                <a class="sortBarText" href="<?php echo build_url(['table' => 's']) ?>">
                    Secondary Weapons
                </a>
                <h1 class="sortBarCut">|</h1>
                <a class="sortBarText" href="<?php echo build_url(['table' => 'm']) ?>">
                    Melee Weapons
                </a>
            </div>

            <div class="orderBar">
                <a class="orderBarText" href="<?php echo build_url(['order' => 'n', 'order_dir' => toggle_order_dir('n')]); ?>">
                    Name
                </a>
                <h1 class="orderBarCut">|</h1>
                <a class="orderBarText" href="<?php echo build_url(['order' => 'rd', 'order_dir' => toggle_order_dir('rd')]) ?>">
                    Release Order
                </a>
                <h1 class="orderBarCut">|</h1>
                <a class="orderBarText" href="<?php echo build_url(['order' => 'rot', 'order_dir' => toggle_order_dir('rot')]) ?>">
                    Release Order by Type
                </a>
            </div>

            <?php
                $allowed_tables = ['warframes', 'primaries', 'secondaries', 'melees'];
                if (!in_array($t, $allowed_tables)) {
                    $t = 'warframes';
                }

                $order_dir = strtoupper($_GET['order_dir'] ?? 'asc');

                if (!in_array($order_dir, ['ASC', 'DESC'])) {
                    $order_dir = 'ASC';
                }

                $query = "SELECT * FROM `$t` WHERE MASTERY <= " . ($user_data['MASTERY_RANK'] / 100) . " ORDER BY $sort $order_dir";

                if (!empty($search)) {
                    $query .= " WHERE NAME LIKE '%$search%'";
                }
                $result = mysqli_query($dbc, $query);

                echo '<div class="codexList">';
                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo '<a class="codexItem" ' . 
                            (!empty($row['IMAGE_LINK']) ? 'style="background-image: url(' . $row['IMAGE_LINK'] . ')"' : '') . 
                            "href=''" . '>';
                        echo '<h3>' . htmlspecialchars($row['NAME']) . '</h3>';
                        echo '</a>';
                    }
                } else {
                    echo '<p>No entries found in ' . htmlspecialchars($t) . '.</p>';
                }
                echo '</div>';
            ?>
        </main>

        <?php include("assets/includes/footer.html"); ?>
    </body>
</html>